package cn.tuia.payment.api.constants;

import java.util.Objects;

/**
 * @author lizhiheng
 */
public class RedisKey {
    /**
     * 例子：55502_BANK_MER_PERIOD_1_POOL
     * 55502商户在第1时间段内的子商户池
     * 尽量使用下面这个方法，formatPoolKey，参数不容易传错位置
     */
    private static final String BANK_MER_PERIOD_POOL = "%s_BANK_MER_PERIOD_%s_POOL";

    private static final String BANK_MER_PERIOD_POOL_V2 = "%s_%s_BANK_MER_PERIOD_%s_POOL";

    public static String formatPoolKey(String merId, int period) {
        return String.format(BANK_MER_PERIOD_POOL, merId, period);
    }

    /**
     * 自定义商户池
     */
    public static String formatPoolKeyV2(String merId, int period, Long poolId) {
        if (Objects.isNull(poolId) || Objects.equals(poolId, 0L)) {
            return formatPoolKey(merId, period);
        }
        return String.format(BANK_MER_PERIOD_POOL_V2, poolId, merId, period);
    }
}
