package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: BankMerPoolEntity
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.09.02 13:53
 */
@Data
@TableName("tb_bank_mer_pool")
public class BankMerPoolEntity implements Serializable {

    private static final long serialVersionUID = -102555067001252889L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField("gmt_modified")
    private Date gmtModified;

    /**
     * 渠道
     */
    @TableField("channel")
    private Integer channel;

    /**
     * 类型（联动-商户号；银联-渠道）
     */
    @TableField("type")
    private String type;

    /**
     * 名称
     */
    @TableField("name")
    private String name;

    /**
     * 创建人id
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 最后编辑人id
     */
    @TableField("last_admin_id")
    private String lastAdminId;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 关联
     */
    @TableField("relation")
    private String relation;

    /**
     * 扩展字段
     */
    @TableField("extra")
    private String extra;
}
