/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.constants;

import cn.tuia.payment.api.enums.PaymentChannelEnum;
import java.util.Objects;

public class SomeConstants {
    private static final String LD_RELEASING_NUM_CONFIG = "%s_ld_releasing_num_config";
    private static final String LD_RELEASING_NUM_CONFIG_V2 = "%s_ld_releasing_num_config_v2";
    private static final String LD_REMAINING_NUM_CONFIG = "%s_ld_remaining_num_config";
    private static final String LD_PULL_UP_RATE_CONFIG = "%s_ld_pull_up_rate_config";
    private static final String LD_RELEASING_UPDATE_CONFIG = "ld_releasing_update_config";
    private static final String UP_RELEASING_NUM_CONFIG = "%s_up_releasing_num_config";
    private static final String UP_RELEASING_NUM_CONFIG_V2 = "%s_up_releasing_num_config_v2";
    private static final String UP_REMAINING_NUM_CONFIG = "%s_up_remaining_num_config";
    private static final String UP_PULL_UP_RATE_CONFIG = "%s_up_pull_up_rate_config";
    private static final String UP_RELEASING_UPDATE_CONFIG = "up_releasing_update_config";
    private static final String POOL_TIME_PERIOD_CONFIG = "%s_pool_time_period_config";
    private static final String POOL_RELEASING_UPDATE_CONFIG = "%s_pool_releasing_update_config";
    private static final String POOL_REMAINING_NUM_CONFIG_V2 = "%s_remaining_num_configV2";
    private static final String POOL_ACCOUNT_NURTURING_CONFIG = "%s_account_nurturing_config";

    public static String getPoolAccountNurturingConfig(Long poolId) {
        return String.format(POOL_ACCOUNT_NURTURING_CONFIG, poolId);
    }

    public static String getPoolReleasingUpdateConfig(Integer channel, Long poolId) {
        if (Objects.isNull(poolId) || Objects.equals(poolId, 0L)) {
            return Objects.equals(channel, PaymentChannelEnum.LIANDONG.getCode()) ? LD_RELEASING_UPDATE_CONFIG : (Objects.equals(channel, PaymentChannelEnum.UNION_PAY.getCode()) ? UP_RELEASING_UPDATE_CONFIG : null);
        }
        return String.format(POOL_RELEASING_UPDATE_CONFIG, poolId);
    }

    public static String getLdReleasingNumConfig(String merId) {
        return String.format(LD_RELEASING_NUM_CONFIG, merId);
    }

    public static String getUpReleasingNumConfig(String merId) {
        return String.format(UP_RELEASING_NUM_CONFIG, merId);
    }

    public static String getRemainingNumConfigV2(Integer channel, String type, Long poolId) {
        if (Objects.isNull(poolId) || Objects.equals(poolId, 0L)) {
            return Objects.equals(channel, PaymentChannelEnum.LIANDONG.getCode()) ? SomeConstants.getLdRemainingNumConfig(type) : (Objects.equals(channel, PaymentChannelEnum.UNION_PAY.getCode()) ? SomeConstants.getUpRemainingNumConfig(type) : null);
        }
        return String.format(POOL_REMAINING_NUM_CONFIG_V2, poolId);
    }

    public static String getLdRemainingNumConfig(String merId) {
        return String.format(LD_REMAINING_NUM_CONFIG, merId);
    }

    public static String getUpRemainingNumConfig(String merId) {
        return String.format(UP_REMAINING_NUM_CONFIG, merId);
    }

    public static String getReleasingNumConfigKey(Integer paymentChannel, String code, Long poolId) {
        return Objects.equals(paymentChannel, PaymentChannelEnum.LIANDONG.getCode()) ? SomeConstants.getLdReleasingNumConfigV2(code, poolId) : (Objects.equals(paymentChannel, PaymentChannelEnum.UNION_PAY.getCode()) ? SomeConstants.getUpReleasingNumConfigV2(code, poolId) : null);
    }

    private static String getUpReleasingNumConfigV2(String merId, Long poolId) {
        if (Objects.isNull(poolId) || Objects.equals(poolId, 0L)) {
            return String.format(UP_RELEASING_NUM_CONFIG_V2, merId);
        }
        return SomeConstants.getPoolTimePeriodConfig(poolId);
    }

    private static String getLdReleasingNumConfigV2(String merId, Long poolId) {
        if (Objects.isNull(poolId) || Objects.equals(poolId, 0L)) {
            return String.format(LD_RELEASING_NUM_CONFIG_V2, merId);
        }
        return SomeConstants.getPoolTimePeriodConfig(poolId);
    }

    private static String getPoolTimePeriodConfig(Long poolId) {
        return String.format(POOL_TIME_PERIOD_CONFIG, poolId);
    }

    public static String getLdPullUpRateConfig(String merId) {
        return String.format(LD_PULL_UP_RATE_CONFIG, merId);
    }

    public static String getUpPullUpRateConfig(String merId) {
        return String.format(UP_PULL_UP_RATE_CONFIG, merId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SomeConstants)) {
            return false;
        }
        SomeConstants other = (SomeConstants)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof SomeConstants;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "SomeConstants()";
    }
}

