package cn.tuia.payment.api.constants;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.concurrent.TimeUnit;

/**
 * @author y.zhao
 * @title: RedisKeyEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.09.13 10:26
 */
@Getter
@AllArgsConstructor
public enum RedisKeyEnum {

    BANK_MER_POOL_ID_SET("%s_BANK_MER_POOL_ID_SET", 1, TimeUnit.DAYS),
    BANK_MER_POOL_4_RELATION("%s_BANK_MER_POOL_4_RELATION", 1, TimeUnit.DAYS),
    BANK_MER_POOL_4_POOL_ID("%s_BANK_MER_POOL_4_POOL_ID", 1, TimeUnit.DAYS),
    ;

    private final String key;
    private final Integer timeout;
    private final TimeUnit unit;

    /**
     * 商户池信息缓存key （关联积木id）
     */
    public static String getRelationKey(String relationId) {
        return String.format(BANK_MER_POOL_4_RELATION.getKey(), relationId);
    }

    /**
     * 商户池信息缓存key （pool_id）
     */
    public static String getPoolIdKey(Long poolId) {
        return String.format(BANK_MER_POOL_4_POOL_ID.getKey(), poolId);
    }

    /**
     * 渠道 商户池id_set key
     *
     * @param paymentChannel
     * @return
     */
    public static String getChannelPoolKey(Integer paymentChannel) {
        return String.format(BANK_MER_POOL_ID_SET.getKey(), paymentChannel);
    }
}
