package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: Authorization
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.07.23 19:15
 */
@Getter
@Setter
@TableName("tb_authorization")
public class AuthorizationEntity implements Serializable {
    private static final long serialVersionUID = -2028014306474143283L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified", update = "CURRENT_TIMESTAMP")
    private Date gmtModified;

    /**
     * 类型
     *
     * @see cn.tuia.payment.api.enums.AuthorizationTypeEnum
     */
    @TableField("type")
    private Integer type;

    /**
     * 令牌
     */
    @TableField("access_token")
    private String accessToken;

    /**
     * 过期时间
     */
    @TableField("expire_time")
    private Date expireTime;

    /**
     * 扩展字段
     */
    @TableField("extra")
    private String extra;


    /**
     * 编码
     */
    @TableField("code")
    private String code;
}
