package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.github.jeffreyning.mybatisplus.anno.MppMultiId;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhiheng
 */
@Data
@TableName("tb_refund_order")
public class RefundOrderEntity implements Serializable {
    private static final long serialVersionUID = -1344612553956577407L;
    /**
     * id
     */
    @TableId(value = "id")
    @MppMultiId
    private Long id;

    /**
     * 推啊订单id
     */
    @TableField("tuia_id")
    private String tuiaId;

    /**
     * 内部订单id
     */
    @TableField("order_id")
    private String orderId;

    /**
     * 流水线号
     */
    @TableField("bank_order_id")
    private String bankOrderId;


    /**
     * 退款方式
     */
    @TableField("refund_way")
    private Integer refundWay;

    /**
     * 退款金额
     */
    @TableField("refund_amount")
    private Long refundAmount;

    /**
     * 内部退款请求id
     */
    @TableField("refund_req_no")
    private String refundReqNo;

    /**
     * 退款时间
     */
    @TableField("refund_time")
    private Date refundTime;

    /**
     * 退款状态
     */
    @TableField("refund_status")
    private Integer refundStatus;

    /**
     * 积木id
     */
    @TableField("jimu_id")
    private String jimuId;

    /**
     * ip
     */
    @TableField("ip")
    private String ip;

    /**
     * refund_times
     */
    @TableField("refund_times")
    private Integer refundTimes;

    /**
     * 记录创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;
}
