package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * @author lizhiheng
 */

/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum RefundStatusEnum {
    REFUND_INITIAL(1, "", "退款单初始化", "", "", "", ""),
    REFUND_IN_DB_WX(58, "", "微信小程序退款入库了", "", "", "", ""),
    REFUND_IN_DB(59, "", "退款入库了", "", TransStateEnum.INI.getCode(), "退款失败，请稍后再试或联系客服进行退款", ""),
    REFUND_SUCCESS(60, "REFUND_SUCCESS", "退费成功", "SUCCESS", TransStateEnum.SUCCESS.getCode(), "REFUND_SUCCESS","提交成功！退款将在10分钟之内原路返回，请关注账户余额"),
    REFUND_FAIL(70, "REFUND_FAIL", "您的订单退款失败，请稍后再试或联系客服进行退款", "FAIL", TransStateEnum.FAILED.getCode(),"REFUND_FAILED", "退款失败，请稍后再试或联系客服进行退款"),
    REFUND_WILL_BE_PROCESS_TILL_1230(79, "", "您的退款订单已提交，请关注账户余额", "", "", "","提交成功！退款将在10分钟之内原路返回，请关注账户余额" ),
    REFUND_PROCESS(80, "REFUND_PROCESSING", "退费处理中", "PROCESSING", TransStateEnum.ING.getCode(), "", "提交成功！退款将在10分钟之内原路返回，请关注账户余额"),//	商户发起退费请求后，平台受理成功，则会返回此状态。
    REFUND_UNKNOWN(90, "", "退费结果不明", "UNKNOWN", "", "", "退款失败，请稍后再试或联系客服进行退款"),//	当退费由于网络等诸多因素造成超时时，会返回此状态。
    REFUND_WAIT_AUDIT(100, "", "等待人工审核", "", "", "", "提交成功！退款将在10分钟之内原路返回，请关注账户余额"),// 企业版人工操作退款,查询退款状态时会返回。
    MER_PROCESS(110, "", "您的订单退款失败，请联系人工客服进行退款", "", "", "", "退款失败，请稍后再试或联系客服进行退款"),//	查询返回此字段需调用退款信息补录接口进行退款信息补录。
    ;

    public static void main(String[] args) {
        Integer i = chenshi2Code("F");
        System.out.println(i);
    }

    private final Integer code;
    private final String fubeiCode;
    private final String msg;
    private final String unionPayCode;
    private final String chengshiPayCode;
    private final String sandPayCode;
    private final String desc;

    // 允许重新退款的状态列表
    public static final List<Integer> canRefundStatusList = Arrays.asList(REFUND_IN_DB.getCode(), REFUND_FAIL.getCode(), REFUND_UNKNOWN.getCode(), MER_PROCESS.getCode());

    // 退款成功状态列表
    public static final List<Integer> successRefundStatus = Arrays.asList(REFUND_SUCCESS.getCode());

    // 退款中状态列表
    public static final List<Integer> processRefundStatus = Arrays.asList(REFUND_PROCESS.getCode(), REFUND_WAIT_AUDIT.getCode());

    // 报警状态列表/或者退款失败状态
    public static final List<Integer> refundWarnStatus = Arrays.asList(REFUND_IN_DB.getCode(), REFUND_FAIL.getCode(), REFUND_UNKNOWN.getCode(), MER_PROCESS.getCode());


    /**
     * 根据code 返回 desc
     */
    public static String getDescByCode(Integer code) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (value.getCode().equals(code)) {
                return value.getDesc();
            }
        }
        return null;
    }

    /**
     * 根据code获取msg
     */
    public static String getMsg(Integer code) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (java.util.Objects.equals(value.getCode(), code)) {
                return value.getMsg();
            }
        }
        return null;
    }


    /**
     * 根据code获取msg
     */
    public static RefundStatusEnum getMsgByCode(Integer code) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (java.util.Objects.equals(value.getCode(), code)) {
                return value;
            }
        }
        return REFUND_PROCESS;
    }

    /**
     * 是否可以发起退款
     */
    public static boolean canRefund(Integer status) {
        return java.util.Objects.nonNull(status) && (REFUND_INITIAL.getCode().equals(status) || fail(status));
    }

    /**
     * 是否失败
     */
    public static boolean fail(Integer status) {
        return java.util.Objects.equals(REFUND_UNKNOWN.getCode(), status) || java.util.Objects.equals(MER_PROCESS.getCode(), status) || java.util.Objects.equals(REFUND_FAIL.getCode(), status);
    }


    /**
     * 杉德 用
     */
    public static Integer sand2Code(String status) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (value.getSandPayCode().equalsIgnoreCase(status)) {
                return value.getCode();
            }
        }
        return MER_PROCESS.getCode();
    }

    /**
     * 橙释 用
     */
    public static Integer chenshi2Code(String status) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (value.getChengshiPayCode().equalsIgnoreCase(status)) {
                return value.getCode();
            }
        }
        return MER_PROCESS.getCode();
    }

    /**
     * 银联
     */
    public static Integer unionPay2Code(String status) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (value.getUnionPayCode().equalsIgnoreCase(status)) {
                return value.getCode();
            }
        }
        return MER_PROCESS.getCode();
    }

    /**
     * ！！这个方法只能给联动用，因为联动的枚举值是根据枚举的name()来的
     */
    public static Integer liandongTrans2code(String status) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (value.name().equalsIgnoreCase(status)) {
                return value.getCode();
            }
        }
        return MER_PROCESS.getCode();
    }

    /**
     * ！！这个方法只能给付呗用，因为付呗的枚举值是根据fubeiCode来的
     */
    public static Integer fubeiTrans2code(String status) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (value.getFubeiCode().equalsIgnoreCase(status)) {
                return value.getCode();
            }
        }
        return MER_PROCESS.getCode();
    }
//
//    public static Integer transComplainRefundStatus(Integer status) {
//        if (Objects.equal(status, REFUND_IN_DB_WX.getCode()) || Objects.equal(status, REFUND_IN_DB.getCode())) {
//            return ComplaintRefundStatusEnum.NO_REFUND.getCode();
//        } else if (Objects.equal(status, REFUND_SUCCESS.getCode())) {
//            return ComplaintRefundStatusEnum.SUCCESS.getCode();
//        } else if (Objects.equal(status, REFUND_PROCESS.getCode()) || Objects.equal(status, REFUND_WAIT_AUDIT.getCode())) {
//            return ComplaintRefundStatusEnum.ING.getCode();
//        } else {
//            return ComplaintRefundStatusEnum.FAIL.getCode();
//        }
//    }
}
