package cn.tuia.payment.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.entity.AuthorizationEntity;

/**
 * @author y.zhao
 * @title: RemoteAuthorizationService
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.07.23 19:27
 */
@AdvancedFeignClient
public interface RemoteAuthorizationService {

    /**
     * 根据类型 获取 有效的认证信息
     *
     * @param type
     * @return
     */
    AuthorizationEntity getByType(Integer type);


    /**
     * 根据code 获取 有效的认证信息
     */
    AuthorizationEntity getByCode(String code);


    /**
     * 写入最新认证信息
     * todo 做一道缓存
     *
     * @param entity
     */
    void upsert(AuthorizationEntity entity);
}
