/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.constants;

import java.util.concurrent.TimeUnit;

public enum RedisKeyEnum {
    BANK_MER_POOL_ID_SET("%s_BANK_MER_POOL_ID_SET", 1, TimeUnit.DAYS),
    BANK_MER_POOL_4_RELATION("%s_BANK_MER_POOL_4_RELATION", 1, TimeUnit.DAYS),
    BANK_MER_POOL_4_POOL_ID("%s_BANK_MER_POOL_4_POOL_ID", 1, TimeUnit.DAYS);

    private final String key;
    private final Integer timeout;
    private final TimeUnit unit;

    public static String getRelationKey(String relationId) {
        return String.format(BANK_MER_POOL_4_RELATION.getKey(), relationId);
    }

    public static String getPoolIdKey(Long poolId) {
        return String.format(BANK_MER_POOL_4_POOL_ID.getKey(), poolId);
    }

    public static String getChannelPoolKey(Integer paymentChannel) {
        return String.format(BANK_MER_POOL_ID_SET.getKey(), paymentChannel);
    }

    public String getKey() {
        return this.key;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    private RedisKeyEnum(String key, Integer timeout, TimeUnit unit) {
        this.key = key;
        this.timeout = timeout;
        this.unit = unit;
    }
}

