/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.enums;

import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;

public enum BankMerTimePeriodEnums {
    OTHER(0, "\u672a\u914d\u7f6e"),
    ONE(1, "0-6"),
    TWO(2, "6-12"),
    THREE(3, "12-18"),
    FOUR(4, "18-24");

    private final Integer code;
    private final String msg;
    public static final List<Integer> VALID_LIST;

    public static boolean isValid(Integer code) {
        return code != null && VALID_LIST.contains(code);
    }

    public static BankMerTimePeriodEnums determineCurrentPeriod() {
        LocalTime now = LocalTime.now();
        int hour = now.getHour();
        if (hour < 6) {
            return ONE;
        }
        if (hour < 12) {
            return TWO;
        }
        if (hour < 18) {
            return THREE;
        }
        return FOUR;
    }

    public static BankMerTimePeriodEnums determineNextCurrentPeriod() {
        LocalTime now = LocalTime.now();
        int hour = now.getHour();
        if (hour < 6) {
            return TWO;
        }
        if (hour < 12) {
            return THREE;
        }
        if (hour < 18) {
            return FOUR;
        }
        return ONE;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    private BankMerTimePeriodEnums(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    static {
        VALID_LIST = Arrays.asList(ONE.getCode(), TWO.getCode(), THREE.getCode(), FOUR.getCode());
    }
}

