/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.enums;

public enum PayStatusEnum {
    NO_ORDER(-1, "\u6ca1\u6709\u8ba2\u5355", ""),
    WAIT_BUYER_PAY(10, "\u4ea4\u6613\u521b\u5efa\uff0c\u7b49\u5f85\u4e70\u5bb6\u4ed8\u6b3e", ""),
    USER_PAYING(15, "\u7528\u6237\u652f\u4ed8\u4e2d", "USERPAYING"),
    TRADE_SUCCESS(20, "\u4ea4\u6613\u6210\u529f\uff0c\u4e0d\u80fd\u518d\u6b21\u8fdb\u884c\u4ea4\u6613", "SUCCESS"),
    TRADE_CLOSE(30, "\u4ea4\u6613\u5173\u95ed\uff0c \u5728\u6307\u5b9a\u65f6\u95f4\u6bb5\u5185\u672a\u652f\u4ed8\u65f6\u5173\u95ed\u7684\u4ea4\u6613", "CLOSED"),
    REVOKING(35, "\u64a4\u9500\u4e2d", "REVOKING"),
    TRADE_CANCEL(40, "\u4ea4\u6613\u64a4\u9500", "REVOKED"),
    TRADE_FAIL(50, "\u4ea4\u6613\u5931\u8d25", ""),
    REVERSE_SUCCESS(100, "\u9000\u6c47\u6210\u529f", "");

    private final Integer code;
    private final String msn;
    private final String fubeiCode;

    public static Integer liandongTrans2code(String status) {
        for (PayStatusEnum value : PayStatusEnum.values()) {
            if (!value.name().equals(status)) continue;
            return value.getCode();
        }
        return null;
    }

    public static Integer fubeiTrans2code(String status) {
        for (PayStatusEnum value : PayStatusEnum.values()) {
            if (!value.getFubeiCode().equals(status)) continue;
            return value.getCode();
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsn() {
        return this.msn;
    }

    public String getFubeiCode() {
        return this.fubeiCode;
    }

    private PayStatusEnum(Integer code, String msn, String fubeiCode) {
        this.code = code;
        this.msn = msn;
        this.fubeiCode = fubeiCode;
    }
}

