package cn.tuia.payment.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.AuthorizationDTO;
import cn.tuia.payment.api.entity.AuthorizationEntity;

import java.util.List;

/**
 * @author y.zhao
 * @title: RemoteAuthorizationService
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.07.23 19:27
 */
@AdvancedFeignClient
public interface RemoteAuthorizationService {


    /**
     * 根据code 获取 有效的认证信息
     */
    AuthorizationEntity getByCode(String code);


    /**
     * 根据code 获取 有效的认证信息
     */
    AuthorizationDTO getByCode(Integer type, String code);

    /**
     * 写入最新认证信息
     * todo 做一道缓存
     *
     * @param entity
     */
    void upsert(AuthorizationEntity entity);

    /**
     * 列表
     *
     * @param type
     * @return
     */
    List<AuthorizationDTO> getListByType(Integer type);

    /**
     * 删除
     *
     * @param type
     * @param code
     * @return
     */
    Boolean delete(Integer type, String code);
}
