package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 用户主表
 * </p>
 *
 * @author hong
 * @since 2024/01/24
 */
@Getter
@Setter
@TableName("tb_main_user")
public class MainUserEntity implements Serializable {

    private static final long serialVersionUID = 2437835831473022956L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 前端生成，和手机号绑定
     */
    @TableField("uuid")
    private String uuid;

    /**
     * 手机号
     */
    @TableField("phone")
    private String phone;

    /**
     * 社保类型 (1: 有社保, 2: 无社保)
     */
    @TableField("social_security_type")
    private Integer socialSecurityType;

    /**
     * 姓名
     */
    @TableField("name")
    private String name;

    /**
     * 身份证
     */
    @TableField("id_card")
    private String idCard;

    /**
     * 记录创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;


}
