package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 客诉记录表
 *
 * @author lizhiheng
 */
@Data
@TableName("tb_complain_record")
public class ComplainRecordEntity implements Serializable {

    private static final long serialVersionUID = 8836011206408888863L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "CURRENT_TIMESTAMP")
    private Date gmtModified;

    /**
     * 订单号
     */
    @TableField("order_id")
    private String orderId;

    /**
     * tuia订单号
     */
    @TableField("tuia_id")
    private String tuiaId;

    /**
     * 投诉时间
     */
    @TableField("gmt_complaint")
    private Date gmtComplaint;

    /**
     * 渠道
     */
    @TableField("channel")
    private Integer channel;

}