package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * @author y.zhao
 * @title: ComplainStatusEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.06 14:49
 */
@Getter
@AllArgsConstructor
public enum ComplainStatusLiandongWxEnum {


    /**
     * 待处理
     */
    PENDING("待处理"),

    /**
     * 处理中
     */
    PROCESSING("处理中"),

    /**
     * 已处理完成
     */
    PROCESSED("已处理完成"),
    ;

    private final String description;

    // 需要退款的状态
    public final static List<String> REFUND_STATUS_LIST = Arrays.asList(PENDING.name(), PROCESSING.name());

    public static String getDesc(String name) {
        for (ComplainStatusLiandongWxEnum value : ComplainStatusLiandongWxEnum.values()) {
            if (value.name().equals(name)) {
                return value.getDescription();
            }
        }
        return null;
    }
}
