package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * 推啊的支付方式收敛
 * @author lizhiheng
 */

@AllArgsConstructor
@Getter
public enum TuiaPayWayEnum {
    ALIPAY(1),
    WECHAT_PAY(2),
    ;
    private final Integer code;

    public static final List<Integer> ALI_PAY = Arrays.asList(PayWayEnum.ALIPAY.getCode(), PayWayEnum.ALIPAY_H5_PAY.getCode(), PayWayEnum.ALIPAY_QR_PAY.getCode());
    public static final List<Integer> WE_CHAT_PAY = Arrays.asList(PayWayEnum.WECHAT_CLOUD_PAY.getCode(), PayWayEnum.WECHAT_PAY.getCode());
}
