/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.enums;

import cn.tuia.payment.api.enums.RefundStatusEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum ComplaintRefundStatusEnum {
    NO_REFUND(0, new ArrayList<Integer>(), "\u672a\u9000\u6b3e"),
    SUCCESS(1, Arrays.asList(RefundStatusEnum.REFUND_SUCCESS.getCode()), "\u9000\u6b3e\u6210\u529f"),
    ING(2, RefundStatusEnum.processRefundStatus, "\u9000\u6b3e\u4e2d"),
    FAIL(3, RefundStatusEnum.refundWarnStatus, "\u9000\u6b3e\u5931\u8d25");

    private final Integer code;
    private final List<Integer> refundStatusCode;
    private final String desc;

    public static String getDesc(Integer code) {
        for (ComplaintRefundStatusEnum value : ComplaintRefundStatusEnum.values()) {
            if (!value.getRefundStatusCode().contains(code)) continue;
            return value.getDesc();
        }
        return null;
    }

    public static List<Integer> getRefundStatus(Integer code) {
        for (ComplaintRefundStatusEnum value : ComplaintRefundStatusEnum.values()) {
            if (!value.getCode().equals(code)) continue;
            return value.getRefundStatusCode();
        }
        return new ArrayList<Integer>();
    }

    public Integer getCode() {
        return this.code;
    }

    public List<Integer> getRefundStatusCode() {
        return this.refundStatusCode;
    }

    public String getDesc() {
        return this.desc;
    }

    private ComplaintRefundStatusEnum(Integer code, List<Integer> refundStatusCode, String desc) {
        this.code = code;
        this.refundStatusCode = refundStatusCode;
        this.desc = desc;
    }
}

