/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.dto.excel.common.converter;

import cn.hutool.poi.excel.ExcelReader;
import cn.tuia.payment.api.dto.excel.MerchantAddExcelItem;
import cn.tuia.payment.api.dto.excel.MerchantUpdateExcelItem;
import cn.tuia.payment.api.dto.excel.common.converter.CsTaskConverter;
import cn.tuia.payment.api.dto.excel.common.handler.CsTaskHandler;
import cn.tuia.payment.api.entity.BankMerBatchUpdateTaskEntity;
import cn.tuia.payment.api.entity.BankMerBatchUpdateTaskItemEntity;
import cn.tuia.payment.api.entity.MerchantEntity;
import cn.tuia.payment.api.enums.BankMerBatchUpdateTaskItemStatusEnums;
import cn.tuia.payment.api.enums.BankMerStatusEnums;
import cn.tuia.payment.api.enums.BankMerTimePeriodEnums;
import cn.tuia.payment.api.enums.ExcelException;
import cn.tuia.payment.api.enums.IndustryEnums;
import cn.tuia.payment.api.enums.OnOffEnum;
import cn.tuia.payment.api.enums.PaymentChannelEnum;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public abstract class CommonBatchConverter<ADD, UPDATE, EXPORT> {
    CommonBatchConverter<ADD, UPDATE, EXPORT> checkTableHeader(ExcelReader excelReader, Class clazz) throws Exception {
        Field[] fields = clazz.getDeclaredFields();
        List list = Arrays.stream(fields).filter(one -> !Modifier.isStatic(one.getModifiers())).map(Field::getName).collect(Collectors.toList());
        Sheet sheet = excelReader.getSheet();
        ArrayList<String> headers = new ArrayList<String>();
        Row headerRow = sheet.getRow(0);
        for (Cell cell : headerRow) {
            String stringCellValue = cell.getStringCellValue();
            if (!StringUtils.isNotEmpty((CharSequence)stringCellValue)) continue;
            headers.add(stringCellValue);
        }
        if (!headers.equals(list)) {
            throw new Exception(ExcelException.HEADER_WRONG.getMessage() + "_" + list);
        }
        return this;
    }

    abstract List<MerchantAddExcelItem> addConverter(ExcelReader var1) throws Exception;

    abstract List<MerchantUpdateExcelItem> updateConverter(ExcelReader var1) throws Exception;

    abstract EXPORT exportConvert();

    public static CommonBatchConverter getConverter(Integer channel) {
        if (PaymentChannelEnum.CHENGSHI.getCode().equals(channel)) {
            return new CsTaskConverter();
        }
        return new CsTaskConverter();
    }

    public static abstract class CommonTaskHandler {
        protected MerchantEntity bankMer;
        protected BankMerBatchUpdateTaskEntity task;
        protected BankMerBatchUpdateTaskItemEntity taskItem;
        protected StringBuilder sb;
        protected boolean nothingChange = true;

        public static CommonTaskHandler fill(MerchantEntity bankMer, BankMerBatchUpdateTaskEntity task, BankMerBatchUpdateTaskItemEntity taskItem) {
            CommonTaskHandler handler = CommonTaskHandler.getConverter(bankMer.getChannel());
            handler.bankMer = bankMer;
            handler.task = task;
            handler.taskItem = taskItem;
            handler.sb = new StringBuilder();
            return handler;
        }

        public static CommonTaskHandler getConverter(Integer channel) {
            if (PaymentChannelEnum.CHENGSHI.getCode().equals(channel)) {
                return new CsTaskHandler();
            }
            return new CsTaskHandler();
        }

        public abstract CommonTaskHandler dealWithTaskItem();

        public CommonTaskHandler dealCommonTaskItem() {
            boolean mainBodyBlankOrSame;
            boolean remarkBlankOrSame;
            Integer newStatus;
            if (!IndustryEnums.isValid(this.taskItem.getIndustry())) {
                this.sb.append("\u884c\u4e1a\u4e0d\u5b58\u5728;");
                this.taskItem.setTaskStatus(BankMerBatchUpdateTaskItemStatusEnums.FAILED.getCode());
                this.taskItem.setMsg(this.sb.toString());
                return this;
            }
            if (Objects.isNull(this.bankMer)) {
                this.sb.append("\u5b50\u5546\u6237id\u4e0d\u5b58\u5728;");
                this.taskItem.setTaskStatus(BankMerBatchUpdateTaskItemStatusEnums.FAILED.getCode());
                this.taskItem.setMsg(this.sb.toString());
                return this;
            }
            if (!BankMerTimePeriodEnums.isValid(this.taskItem.getBankMerPostPeriod())) {
                this.sb.append("\u4f7f\u7528\u65f6\u6bb5\u683c\u5f0f\u9519\u8bef;");
                this.taskItem.setTaskStatus(BankMerBatchUpdateTaskItemStatusEnums.FAILED.getCode());
                this.taskItem.setMsg(this.sb.toString());
                return this;
            }
            if (!BankMerStatusEnums.isValid(this.taskItem.getBankMerPostStatus())) {
                this.sb.append("\u63a8\u554a\u72b6\u6001\u683c\u5f0f\u9519\u8bef;");
                this.taskItem.setTaskStatus(BankMerBatchUpdateTaskItemStatusEnums.FAILED.getCode());
                this.taskItem.setMsg(this.sb.toString());
                return this;
            }
            if (!OnOffEnum.isValid(this.taskItem.getOnOff())) {
                this.sb.append("\u5f00\u5173\u683c\u5f0f\u9519\u8bef;");
                this.taskItem.setTaskStatus(BankMerBatchUpdateTaskItemStatusEnums.FAILED.getCode());
                this.taskItem.setMsg(this.sb.toString());
                return this;
            }
            Integer oldStatus = this.bankMer.getTuiaStatus();
            boolean statusSame = oldStatus.equals(newStatus = this.taskItem.getBankMerPostStatus());
            if (statusSame) {
                this.sb.append("\u5b50\u5546\u6237\u72b6\u6001\u4e00\u81f4\uff0c\u65e0\u9700\u53d8\u66f4;");
            } else {
                this.bankMer.setTuiaStatus(newStatus);
                this.sb.append("\u5b50\u5546\u6237\u72b6\u6001\u53d8\u66f4:").append(BankMerStatusEnums.trans2name(oldStatus)).append("->").append(BankMerStatusEnums.trans2name(newStatus)).append(";");
            }
            Integer oldPeriod = this.bankMer.getTimePeriod();
            Integer newPeriod = this.taskItem.getBankMerPostPeriod();
            boolean periodSame = oldPeriod.equals(newPeriod);
            if (periodSame) {
                this.sb.append("\u5b50\u5546\u6237\u6295\u653e\u65f6\u6bb5\u4e00\u81f4\uff0c\u65e0\u9700\u53d8\u66f4;");
            } else {
                this.bankMer.setTimePeriod(newPeriod);
                this.sb.append("\u5b50\u5546\u6237\u6295\u653e\u65f6\u6bb5\u53d8\u66f4:").append(oldPeriod).append("->").append(newPeriod).append(";");
            }
            String oldRemark = this.bankMer.getRemark();
            String newRemark = this.taskItem.getRemark();
            boolean bl = remarkBlankOrSame = StringUtils.isBlank((CharSequence)newRemark) || newRemark.equals(oldRemark);
            if (remarkBlankOrSame) {
                this.sb.append("\u5907\u6ce8\u4e3a\u7a7a\u6216\u5185\u5bb9\u4e00\u6837\uff0c\u4e0d\u8fdb\u884c\u8986\u76d6;");
            } else {
                this.bankMer.setRemark(newRemark);
                this.sb.append("\u5907\u6ce8\u53d8\u66f4:").append(oldRemark).append("->").append(newRemark).append(";");
            }
            String oldMainBody = this.bankMer.getMainBody();
            String newMainBody = this.taskItem.getMainBody();
            boolean bl2 = mainBodyBlankOrSame = StringUtils.isBlank((CharSequence)newMainBody) || Objects.equals(oldMainBody, newMainBody);
            if (mainBodyBlankOrSame) {
                this.sb.append("\u4e3b\u4f53\u4e3a\u7a7a\u6216\u5185\u5bb9\u4e00\u6837\uff0c\u4e0d\u8fdb\u884c\u8986\u76d6;");
            } else {
                this.bankMer.setMainBody(newMainBody);
                this.sb.append("\u4e3b\u4f53\u53d8\u66f4:").append(oldMainBody).append("->").append(newMainBody).append(";");
            }
            Integer newOnOff = OnOffEnum.getCode(this.taskItem.getOnOff());
            boolean onOff = Objects.equals(this.bankMer.getOnOff(), newOnOff);
            if (onOff) {
                this.sb.append("\u5f85\u6295\u653e\u5de1\u68c0\u5f00\u5173\u4e00\u81f4\uff0c\u65e0\u9700\u53d8\u66f4;");
            } else {
                this.bankMer.setOnOff(newOnOff);
                if (Objects.equals(newOnOff, OnOffEnum.ON.getCode())) {
                    this.bankMer.setOnTime(new Date());
                }
                this.sb.append("\u5f85\u6295\u653e\u5de1\u68c0\u5f00\u5173\u53d8\u66f4\u4e3a\uff1a").append(this.taskItem.getOnOff()).append(";");
            }
            this.nothingChange = this.nothingChange && statusSame && periodSame && remarkBlankOrSame && mainBodyBlankOrSame && onOff;
            return this;
        }

        public void done() {
            if (this.nothingChange) {
                this.taskItem.setTaskStatus(BankMerBatchUpdateTaskItemStatusEnums.FAILED.getCode());
            } else {
                this.bankMer.setLastAdminId(this.task.getAdminId());
                this.taskItem.setTaskStatus(BankMerBatchUpdateTaskItemStatusEnums.SUCCESS.getCode());
            }
        }
    }
}

