package cn.tuia.payment.api.dto;

import cn.tuia.payment.api.entity.CustomerComplaintEntity;
import cn.tuia.payment.api.enums.ComplainChannelEnum;
import cn.tuia.payment.api.enums.ComplainStatusEnum;
import cn.tuia.payment.api.enums.ComplaintRefundStatusEnum;
import cn.tuia.payment.api.enums.TuiaPayWayEnum;
import cn.tuia.payment.api.utils.AmountUtil;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: CompliantDTO
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.07 10:26
 */
@Data
public class CompliantDTO implements Serializable {
    private static final long serialVersionUID = -492835667053444344L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 渠道
     */
    private Integer channel;


    /**
     * 渠道 名称
     */
    private String channelName;

    /**
     * 投诉单号
     */
    private String complainNo;

    /**
     * 支付宝交易单号
     */
    private String bankOrderId;

    /**
     * 商家订单号
     */
    private String merOrderNo;

    /**
     * 订单金额
     */
    private String orderAmount;


    /**
     * 交易时间
     */
    private Date gmtTrade;


    /**
     * 投诉时间
     */
    private Date gmtComplain;

    /**
     * 投诉单状态
     *
     * @see cn.tuia.payment.api.enums.ComplainStatusEnum
     */
    private String complainStatus;

    /**
     * 投诉单状态 描述
     */
    private String complainStatusDesc;

    /**
     * 联系方式
     */
    private String contact;


    /**
     * 投诉内容
     */
    private String complainContent;

    /**
     * 退款金额
     */
    private String refundAmount;

    /**
     * 退款结果
     */
    private Integer refundStatus;

    /**
     * 退款结果 描述
     */
    private String refundStatusDesc;

    /**
     * 退款时间
     */
    private Date gmtRefund;

    /**
     * 支付方式
     */
    private String payWay;

    /**
     * 转换
     *
     * @param entity
     * @return
     */
    public static CompliantDTO convert(CustomerComplaintEntity entity) {
        CompliantDTO dto = new CompliantDTO();
        dto.setId(entity.getId());
        dto.setChannel(entity.getChannel());
        dto.setChannelName(ComplainChannelEnum.getMsg(entity.getChannel()));
        dto.setComplainNo(entity.getComplainNo());
        dto.setBankOrderId(entity.getBankOrderNo());
        dto.setMerOrderNo(entity.getMerOrderNo());
        dto.setOrderAmount(entity.getComplainAmount());
        dto.setGmtTrade(entity.getGmtTrade());
        dto.setGmtComplain(entity.getGmtComplain());
        dto.setComplainStatus(entity.getStatus());
        dto.setComplainStatusDesc(ComplainStatusEnum.getDesc(entity.getStatus()));
        dto.setContact(entity.getContact());
        dto.setComplainContent(entity.getComplainContent());
        dto.setRefundAmount(AmountUtil.convertRefundAmountToString(entity.getRefundAmount()));
        dto.setRefundStatus(entity.getRefundStatus());
        dto.setRefundStatusDesc(ComplaintRefundStatusEnum.getDesc(dto.getRefundStatus()));
        if (!entity.getPayWay().isEmpty()) {
            boolean contains = TuiaPayWayEnum.ALI_PAY.contains(entity.getPayWay());
            if (contains) {
                dto.setPayWay(TuiaPayWayEnum.ALIPAY.getName());
            } else {
                dto.setPayWay(TuiaPayWayEnum.WECHAT_PAY.getName());
            }
        } else {
            dto.setPayWay(TuiaPayWayEnum.ALIPAY.getName());
        }
        dto.setGmtRefund(entity.getGmtRefund());
        return dto;
    }
}
