package cn.tuia.payment.api.dto.req;

import lombok.Data;

import java.io.Serializable;

/**
 * @author y.zhao
 * @title: MerchantQuery
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.10.09 16:31
 */
@Data
public class MerchantQuery implements Serializable {
    private static final long serialVersionUID = 1614381107703949257L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 渠道
     */
    private Integer channel;

    /**
     * 类型
     */
    private String type;

    /**
     * 子商户id（二级商户id），和tb_pay_order的bank_merchant_no是一个字段
     */
    private String bankMerId;

    /**
     * 分组，联动的分组
     */
    private String merGroup;

    /**
     * 使用时段，运营维护，一天分为4个时段，1，2，3，4
     */
    private Integer timePeriod;

    /**
     * 渠道状态
     */
    private Integer channelStatus;

    /**
     * 推啊状态
     */
    private Integer tuiaStatus;

    /**
     * 投放状态，待投、在投、下线、未知
     */
    private Integer releaseStatus;

    /**
     * 最近编辑人
     */
    private String lastAdminId;

    /**
     * 商户池id
     */
    private Long poolId;

    /**
     * 主体
     */
    private String mainBody;

    /**
     * 备注
     */
    private String remark;

    /**
     * 开关
     */
    private Integer onOff;

    /**
     * 账户ID
     */
    private Integer authId;
}
