package cn.tuia.payment.api.constants;


import cn.tuia.payment.api.enums.PaymentChannelEnum;
import lombok.Data;

import java.util.Objects;

/**
 * @author lizhiheng
 */
@Data
public class SomeConstants {
    private static final String LD_RELEASING_NUM_CONFIG = "%s_ld_releasing_num_config";
    private static final String LD_RELEASING_NUM_CONFIG_V2 = "%s_ld_releasing_num_config_v2";
    private static final String LD_REMAINING_NUM_CONFIG = "%s_ld_remaining_num_config";
    private static final String LD_PULL_UP_RATE_CONFIG = "%s_ld_pull_up_rate_config";
    private static final String LD_RELEASING_UPDATE_CONFIG = "%s_ld_releasing_update_config";

    private static final String UP_RELEASING_NUM_CONFIG = "%s_up_releasing_num_config";
    private static final String UP_RELEASING_NUM_CONFIG_V2 = "%s_up_releasing_num_config_v2";
    private static final String UP_REMAINING_NUM_CONFIG = "%s_up_remaining_num_config";
    private static final String UP_PULL_UP_RATE_CONFIG = "%s_up_pull_up_rate_config";
    private static final String UP_RELEASING_UPDATE_CONFIG = "%s_up_releasing_update_config";

    // 时段配置 {poolId}_xx
    private static final String POOL_TIME_PERIOD_CONFIG = "%s_pool_time_period_config";
    // 时段配置 默认池 channel_type_poolId
    private static final String POOL_TIME_PERIOD_CONFIG_DEFAULT = "%s_%s_%s_pool_time_period_config_default";
    // 在投自动更新配置 {poolId}_xx
    private static final String POOL_RELEASING_UPDATE_CONFIG = "%s_pool_releasing_update_config";
    private static final String POOL_RELEASING_UPDATE_CONFIG_DEFAULT = "%s_%s_pool_releasing_update_config_default";
    // 在投子商户余量监控告警 配置 {poolId}_xx
    private static final String POOL_REMAINING_NUM_CONFIG_V2 = "%s_remaining_num_configV2";
    // 在投子商户余量监控告警 配置 默认配置：渠道_类型_xxx
    private static final String POOL_REMAINING_NUM_CONFIG_DEFAULT = "%s_%s_remaining_num_config_default";
    // 养号策略 配置  {poolId}_xx
    private static final String POOL_ACCOUNT_NURTURING_CONFIG = "%s_account_nurturing_config";
    // 补单策略 配置key
    private static final String POOL_REPLENISH_CONFIG = "%s_replenish_config";
    // 补单策略 需要补单的jimuId
    public static final String POOL_REPLENISH_JIMU_ID_CONFIG = "pool_replenish_jimu_id_config";

    private static final String PULL_UP_RATE_CONFIG = "%s_%s_pull_up_rate_config";

    /**
     * 养号策略 配置 key
     *
     * @param poolId
     * @return
     */
    public static String getPoolAccountNurturingConfig(Long poolId) {
        return String.format(POOL_ACCOUNT_NURTURING_CONFIG, poolId);
    }

    /**
     * 补单策略 配置 key
     *
     * @param poolId
     * @return
     */
    public static String getReplenishConfig(Long poolId) {
        return String.format(POOL_REPLENISH_CONFIG, poolId);
    }


    /**
     * 商户池 在投池自动更新 配置
     *
     * @param poolId
     * @return
     */
    public static String getPoolReleasingUpdateConfig(Integer channel, Long poolId, String type) {
        if (Objects.isNull(poolId) || Objects.equals(poolId, 0L)) {
            return Objects.equals(channel, PaymentChannelEnum.LIANDONG.getCode()) ? String.format(LD_RELEASING_UPDATE_CONFIG, type) :
                    Objects.equals(channel, PaymentChannelEnum.UNION_PAY.getCode()) ? String.format(UP_RELEASING_UPDATE_CONFIG, type) :
                            String.format(POOL_RELEASING_UPDATE_CONFIG_DEFAULT, channel, type);
        }
        return String.format(POOL_RELEASING_UPDATE_CONFIG, poolId);
    }

    public static String getLdReleasingNumConfig(String merId) {
        return String.format(LD_RELEASING_NUM_CONFIG, merId);
    }

    public static String getUpReleasingNumConfig(String merId) {
        return String.format(UP_RELEASING_NUM_CONFIG, merId);
    }




    /* ******在投子商户余量监控告警 配置key start ******/

    /**
     * 在投子商户余量监控告警 配置key
     *
     * @param channel
     * @param type
     * @param poolId
     * @return
     */
    public static String getRemainingNumConfigV2(Integer channel, String type, Long poolId) {
        if (Objects.isNull(poolId) || Objects.equals(poolId, 0L)) {
            return Objects.equals(channel, PaymentChannelEnum.LIANDONG.getCode()) ? getLdRemainingNumConfig(type) :
                    Objects.equals(channel, PaymentChannelEnum.UNION_PAY.getCode()) ? getUpRemainingNumConfig(type) :
                            getRemainingNumConfigDefault(channel, type);
        } else {
            return String.format(POOL_REMAINING_NUM_CONFIG_V2, poolId);
        }
    }

    public static String getLdRemainingNumConfig(String merId) {
        return String.format(LD_REMAINING_NUM_CONFIG, merId);
    }

    public static String getUpRemainingNumConfig(String merId) {
        return String.format(UP_REMAINING_NUM_CONFIG, merId);
    }

    public static String getRemainingNumConfigDefault(Integer channel, String type) {
        return String.format(POOL_REMAINING_NUM_CONFIG_DEFAULT, channel, type);
    }

    /* ******在投子商户余量监控告警 配置key end ******/

    /* ***** 时间段配置 start ******/

    /**
     * 获取 商户池 时间段配置key
     */
    public static String getReleasingNumConfigKey(Integer paymentChannel, String code, Long poolId) {
        return Objects.equals(paymentChannel, PaymentChannelEnum.LIANDONG.getCode()) ? SomeConstants.getLdReleasingNumConfigV2(code, poolId) :
                Objects.equals(paymentChannel, PaymentChannelEnum.UNION_PAY.getCode()) ? SomeConstants.getUpReleasingNumConfigV2(code, poolId) :
                        getPoolTimePeriodDefaultConfig(paymentChannel, code, poolId);
    }

    /**
     * 银联 时间段配置key
     *
     * @param merId
     * @param poolId
     * @return
     */
    private static String getUpReleasingNumConfigV2(String merId, Long poolId) {
        if (Objects.isNull(poolId) || Objects.equals(poolId, 0L)) {
            return String.format(UP_RELEASING_NUM_CONFIG_V2, merId);
        } else {
            return getPoolTimePeriodConfig(poolId);
        }
    }

    /**
     * 联动 时间段配置key
     *
     * @param merId
     * @param poolId
     * @return
     */
    private static String getLdReleasingNumConfigV2(String merId, Long poolId) {
        if (Objects.isNull(poolId) || Objects.equals(poolId, 0L)) {
            return String.format(LD_RELEASING_NUM_CONFIG_V2, merId);
        } else {
            return getPoolTimePeriodConfig(poolId);
        }
    }

    /**
     * 商户池 时间段 配置
     *
     * @param poolId
     * @return
     */
    private static String getPoolTimePeriodConfig(Long poolId) {
        return String.format(POOL_TIME_PERIOD_CONFIG, poolId);
    }

    private static String getPoolTimePeriodDefaultConfig(Integer channel, String type, Long poolId) {
        return String.format(POOL_TIME_PERIOD_CONFIG_DEFAULT, channel, type, poolId);
    }


    /* ***** 时间段配置 end ******/


    public static String getLdPullUpRateConfig(String merId) {
        return String.format(LD_PULL_UP_RATE_CONFIG, merId);
    }

    public static String getUpPullUpRateConfig(String merId) {
        return String.format(UP_PULL_UP_RATE_CONFIG, merId);
    }

    public static String getPullUpRateConfig(Integer channel, String type) {
        // 银联 联动 还是用老的配置，其他行业走新的配置 channel_type_xxx
        if (Objects.equals(channel, PaymentChannelEnum.LIANDONG.getCode())) {
            return getLdPullUpRateConfig(type);
        } else if (Objects.equals(channel, PaymentChannelEnum.UNION_PAY.getCode())) {
            return getUpPullUpRateConfig(type);
        } else {
            return String.format(PULL_UP_RATE_CONFIG, channel, type);
        }
    }

}