package cn.tuia.payment.api.dto;

import cn.tuia.payment.api.entity.ConfigPageEntity;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.google.common.base.Strings;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author y.zhao
 * @title: ConfigPageDTO
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.09.23 13:50
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Slf4j
public class ConfigPageDTO extends ConfigPageEntity {
    private static final long serialVersionUID = -8921323265749356212L;

    /**
     * 配置信息，包含不同类型的短信配置
     */
    private Map<String, ConfigPageInfoDTO> configMap = new HashMap<>();

    public static ConfigPageDTO build(ConfigPageEntity entity) {
        if (entity == null) {
            return null;  // Handle null input
        }

        ConfigPageDTO dto = new ConfigPageDTO();
        BeanUtils.copyProperties(entity, dto);

        // Parse the config string into a map
        String config = entity.getConfig();
        if (StringUtils.hasText(config)) {
            try {
                // Parse config JSON into a map
                Map<String, ConfigPageInfoDTO> parsedConfigMap = JSON.parseObject(config,
                        new TypeReference<Map<String, ConfigPageInfoDTO>>() {
                        });
                dto.setConfigMap(parsedConfigMap);
            } catch (Exception e) {
                log.error("Failed to parse config JSON: {}", config, e);
            }
        }
        return dto;
    }

    public static ConfigPageEntity build(ConfigPageDTO dto) {
        if (dto == null) {
            return null;
        }
        ConfigPageEntity entity = new ConfigPageDTO();
        BeanUtils.copyProperties(dto, entity);

        if (Objects.nonNull(dto.getConfigMap())) {
            entity.setConfig(JSON.toJSONString(dto.getConfigMap()));
        }
        return entity;
    }
}
