package cn.tuia.payment.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.BankMerDTO;
import cn.tuia.payment.api.dto.BankMerPoolDTO;
import cn.tuia.payment.api.dto.TimePeriodConfigDTO;
import cn.tuia.payment.api.dto.req.*;
import cn.tuia.payment.api.dto.req.up.UpBankMerQuery;
import cn.tuia.payment.api.dto.rsp.MerPoolStrategyRsp;
import cn.tuia.payment.api.dto.rsp.ResultPage;
import cn.tuia.payment.api.entity.BankMerPoolEntity;

import java.util.List;

/**
 * @author y.zhao
 * @title: RemoteBankMerPoolService
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.09.02 11:38
 */
@AdvancedFeignClient
public interface RemoteBankMerPoolService {

    /**
     * 分页查询
     *
     * @param query
     * @return
     */
    ResultPage<BankMerPoolDTO> page(ReqPageQuery<BankMerPoolQuery> query);

    /**
     * 根据id查询商户池
     * 包含配置信息
     *
     * @param id
     * @return
     */
    BankMerPoolDTO getById(Long id);

    /**
     * 创建/更新
     *
     * @param req
     * @return
     */
    BankMerPoolDTO upsert(BankMerPoolCreateReq req, String adminId);

    /**
     * 商户池 批量关联 商户号
     *
     * @param req
     * @return
     */
    Boolean relationBankMerId(BankMerRelationReq req, String admin);


    /**
     * 商户池 批量关联 商户号
     * 新接口 针对通用商户号标
     *
     * @param req
     * @return
     */
    Boolean relationBankMerIdV2(BankMerRelationReq req, String admin);


    /**
     * 商户池 批量关联 商户号
     * 根据查询条件批量关联
     * 通用
     *
     * @param query
     * @return
     */
    Boolean relationBankMerId4Query(MerchantRelationQuery query, String admin);

    /**
     * 商户池 批量关联 商户号
     * 根据查询条件批量关联
     * 联动
     *
     * @param query
     * @return
     */
    Boolean relationBankMerId4BankQuery(BankMerRelationQuery query, String admin);


    /**
     * 商户池 批量关联 商户号
     * 根据查询条件批量关联
     * 银联
     *
     * @param query
     * @return
     */
    Boolean relationBankMerId4UpBankQuery(UpBankMerRelationQuery query, String admin);

    /**
     * 删除商户池
     * 会将当前商户池下所有子商户号都写入默认池
     *
     * @param id
     * @param adminId
     * @return
     */
    Boolean deleteById(Long id, String adminId);

    /**
     * 根据渠道查询所有商户池（包含默认池）
     *
     * @param channel
     * @return
     */
    List<BankMerPoolEntity> getAllPoolByChannel(Integer channel);

    /**
     * 默认池列表
     *
     * @return
     */
    List<BankMerPoolDTO> defaultPool();

    /**
     * 商户池 投放策略
     *
     * @return
     */
    List<MerPoolStrategyRsp> merPoolStrategy();

    /**
     * 获取当前时间配置
     *
     * @param type
     * @param paymentChannel
     * @param poolId
     * @return
     */
    TimePeriodConfigDTO.TimePeriodConfigItemDTO findCurrentTimePeriodConfig(String type, Integer paymentChannel, Long poolId);
}
