package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: ComplainRefundEntity
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.06 13:48
 */
@Getter
@Setter
@TableName("tb_complain_refund")
public class ComplainRefundEntity implements Serializable {

    private static final long serialVersionUID = 425274104301765045L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified", update = "CURRENT_TIMESTAMP")
    private Date gmtModified;

    /**
     * 关联 tb_customer_complaint 主键id
     */
    @TableField("complain_id")
    private Long complainId;

    /**
     * 退款结果
     */
    @TableField("refund_result")
    private Integer refundResult;

    /**
     * 退款金额
     */
    @TableField("refund_amount")
    private Long refundAmount;

    /**
     * 退款时间
     */
    @TableField("gmt_refund")
    private Date gmtRefund;

    /**
     * 关联 tb_refund_order 主键id
     */
    @TableField("refund_id")
    private Long refundId;
}
