/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.enums;

import cn.tuia.payment.api.enums.MerchantPayWayEnum;

public enum PayWayEnum {
    ALIPAY(1, "\u652f\u4ed8\u5b9d", MerchantPayWayEnum.ALI_PAY),
    WECHAT_PAY(2, "\u5fae\u4fe1\u652f\u4ed8", MerchantPayWayEnum.WECHAT_PAY),
    WECHAT_CLOUD_PAY(3, "\u5fae\u4fe1\u4e91\u95ea\u4ed8", MerchantPayWayEnum.WECHAT_PAY),
    ALIPAY_QR_PAY(4, "\u652f\u4ed8\u5b9d\u626b\u7801\u652f\u4ed8", MerchantPayWayEnum.ALI_PAY),
    ALIPAY_H5_PAY(5, "\u652f\u4ed8\u5b9dh5\u652f\u4ed8", MerchantPayWayEnum.ALI_PAY);

    private final Integer code;
    private final String name;
    private final MerchantPayWayEnum merchantPayWayEnum;

    public static Integer convert2Code(String name) {
        for (PayWayEnum payWayEnum : PayWayEnum.values()) {
            if (!payWayEnum.getName().equals(name)) continue;
            return payWayEnum.getCode();
        }
        return null;
    }

    public static PayWayEnum fromValue(int value) {
        for (PayWayEnum method : PayWayEnum.values()) {
            if (method.getCode() != value) continue;
            return method;
        }
        throw new IllegalArgumentException("\u672a\u77e5\u7684\u652f\u4ed8\u65b9\u5f0f\u503c: " + value);
    }

    public static String convert2Name(Integer code) {
        for (PayWayEnum payWayEnum : PayWayEnum.values()) {
            if (!payWayEnum.getCode().equals(code)) continue;
            return payWayEnum.getName();
        }
        return "";
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public MerchantPayWayEnum getMerchantPayWayEnum() {
        return this.merchantPayWayEnum;
    }

    private PayWayEnum(Integer code, String name, MerchantPayWayEnum merchantPayWayEnum) {
        this.code = code;
        this.name = name;
        this.merchantPayWayEnum = merchantPayWayEnum;
    }
}

