package cn.tuia.payment.api.dto;

import cn.tuia.payment.api.entity.AuthorizationEntity;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author y.zhao
 * @title: AuthorizationDTO
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.09.29 16:23
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Slf4j
public class AuthorizationDTO extends AuthorizationEntity {
    private static final long serialVersionUID = 6405083843402299650L;

    /**
     * 配置信息
     */
    public AppSecretDTO appSecretDTO;

    public static AuthorizationDTO convert(AuthorizationEntity entity) {
        if (Objects.isNull(entity)) {
            return null;
        }
        AuthorizationDTO dto = new AuthorizationDTO();
        BeanUtils.copyProperties(entity, dto);
        AppSecretDTO parseObject = new AppSecretDTO();
        if (StringUtils.isNotEmpty(entity.getExtra())) {
            try {
                BeanUtils.copyProperties(JSON.parseObject(entity.getExtra(), AppSecretDTO.class), parseObject);
            } catch (Exception e) {
                log.warn("AuthorizationEntity convert to AppSecretDTO error:", e);
            }
        }
        parseObject.setAppId(entity.getCode());
        parseObject.setId(entity.getId());
        dto.setAppSecretDTO(parseObject);
        return dto;
    }

}
