package cn.tuia.payment.api.dto;

import cn.tuia.payment.api.entity.BankMerPoolEntity;
import cn.tuia.payment.api.entity.MerchantEntity;
import cn.tuia.payment.api.enums.PaymentChannelEnum;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.beans.BeanUtils;

import java.util.Map;
import java.util.Objects;

/**
 * @author y.zhao
 * @title: MerchantDTO
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.10.09 16:29
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantDTO extends MerchantEntity {
    private static final long serialVersionUID = -7955739852891154763L;


    /**
     * 商户池名称
     */
    private String poolName;

    /**
     * 扩展字段
     */
    private Object extraObject;


    public static MerchantDTO toDTO(MerchantEntity entity, Map<Long, BankMerPoolEntity> poolEntityMap) {
        MerchantDTO dto = new MerchantDTO();
        BeanUtils.copyProperties(entity, dto);

        if (Objects.nonNull(poolEntityMap)) {
            if (Objects.equals(entity.getPoolId(), 0L)) {
                dto.setPoolName("默认池");
            } else {
                BankMerPoolEntity poolEntity = poolEntityMap.get(entity.getPoolId());
                if (Objects.nonNull(poolEntity)) {
                    dto.setPoolName(poolEntity.getName());
                }
            }
        }

        if (Objects.equals(entity.getChannel(), PaymentChannelEnum.UNION_PAY.getCode()) ||
                Objects.equals(entity.getChannel(), PaymentChannelEnum.GUOGUANG.getCode())) {
            dto.setExtraObject(JSON.parseObject(entity.getExtra(), MerchantExtraUPDTO.class));
        }

        return dto;
    }
}
