package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum PayWayEnum {
    ALIPAY(1, "支付宝", MerchantPayWayEnum.ALI_PAY),
    WECHAT_PAY(2, "微信支付", MerchantPayWayEnum.WECHAT_PAY),
    WECHAT_CLOUD_PAY(3, "微信云闪付", MerchantPayWayEnum.WECHAT_PAY),
    ALIPAY_QR_PAY(4, "支付宝扫码支付", MerchantPayWayEnum.ALI_PAY),
    ALIPAY_H5_PAY(5, "支付宝h5支付", MerchantPayWayEnum.ALI_PAY),
    WX_2_WX_PAY(6, "我们的微信跳拉起我们的支付",MerchantPayWayEnum.WECHAT_PAY),
    WX_2_WX(7, "我们的微信跳转渠道微信",MerchantPayWayEnum.WECHAT_PAY),
    ;

    private final Integer code;
    private final String name;
    private final MerchantPayWayEnum merchantPayWayEnum;


    public static Integer convert2Code(String name) {
        for (PayWayEnum payWayEnum : PayWayEnum.values()) {
            if (payWayEnum.getName().equals(name)) {
                return payWayEnum.getCode();
            }
        }
        return null;
    }

    // 根据值获取枚举实例的静态方法
    public static PayWayEnum fromValue(int value) {
        for (PayWayEnum method : PayWayEnum.values()) {
            if (method.getCode() == value) {
                return method;
            }
        }
        throw new IllegalArgumentException("未知的支付方式值: " + value);
    }

    public static String convert2Name(Integer code) {
        for (PayWayEnum payWayEnum : PayWayEnum.values()) {
            if (payWayEnum.getCode().equals(code)) {
                return payWayEnum.getName();
            }
        }
        return "";
    }
}
