package cn.tuia.payment.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhiheng
 */
@Data
public class PayOrderV2InfoDTO implements Serializable {
    private static final long serialVersionUID = -6452608779634607805L;

    private String orderId;

    /**
     * 支付时间
     */
    private Date payTime;
    private Integer paymentChannel;
    private Long payAmount;

    /**
     * 是否上报，0 没上报 1 上报
     */
    private Integer callbackResult;

    /**
     * 上报类型，1，概率 2，手动
     */
    private Integer callbackType;

    /**
     * 广告id
     */
    private Long adId;

    /**
     * 广告name
     */
    private String adName;

    /**
     * 广告主id
     */
    private Long advertiserId;

    /**
     * 广告主名称
     */
    private String advertiserName;

    /**
     * 媒体id
     */
    private Long mediaId;

    /**
     * 广告位id
     */
    private Long slotId;
}
