package cn.tuia.payment.api.enums;

import com.google.common.base.Objects;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: RefundStrategyEnum
 * @projectName tuia-payment
 * @description: description
 * @date 2024.06.26 14:04
 */
@Getter
@AllArgsConstructor
public enum RefundStrategyEnum {

    ALL_REFUND("allRefund", "全部退款"),
    PART_REFUND("partRefund", "比例退款"),
    NO_REFUND("noRefund", "不退款"),
    ;

    private final String code;
    private final String desc;

    public static boolean checkCode(String code) {
        for (RefundStrategyEnum value : RefundStrategyEnum.values()) {
            if (Objects.equal(code, value.getCode())) {
                return true;
            }
        }
        return false;
    }

}
