package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 杉德sand商户主表
 * </p>
 *
 * @author lizhiheng
 * @since 2024/08/06
 */
@Data
@TableName("tb_sand_bank_mer")
public class SandBankMerEntity implements Serializable {

    private static final long serialVersionUID = 4681852348474208182L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    /**
     * 主商户id，和tb_pay_order表的merchant_no是一个字段
     */
    @TableField("industry")
    private Integer industry;

    /**
     * 门店id
     */
    @TableField("store_id")
    private String storeId;

    /**
     * appId，其实就是前端传的bankMerId（子商户id）
     */
    @TableField("app_id")
    private String appId;


}