package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: ComplainChannelEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.06 14:39
 */
@Getter
@AllArgsConstructor
public enum ComplainChannelEnum {

    LIANDONG(PaymentChannelEnum.LIANDONG.getCode(), "联动"),
    UNION_PAY(PaymentChannelEnum.UNION_PAY.getCode(), "银联"),
    ALIPAY(PaymentChannelEnum.ALI_PAY.getCode(), "推啊支付宝"),
    ZHIFUTONG(PaymentChannelEnum.ZHIFUTONG.getCode(), "支付通"),
    ;

    private final Integer code;
    private final String msg;

    public static String getMsg(Integer code) {
        for (ComplainChannelEnum value : ComplainChannelEnum.values()) {
            if (value.getCode().equals(code)) {
                return value.getMsg();
            }
        }
        return null;
    }
}
