package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum PayStatusEnum {
    NO_ORDER(-1, "没有订单", ""),
    WAIT_BUYER_PAY(10, "交易创建，等待买家付款", ""),
    USER_PAYING(15, "用户支付中", "USERPAYING"),
    TRADE_SUCCESS(20, "交易成功，不能再次进行交易", "SUCCESS"),
    TRADE_CLOSE(30, "交易关闭， 在指定时间段内未支付时关闭的交易", "CLOSED"),
    REVOKING(35, "撤销中", "REVOKING"),
    TRADE_CANCEL(40, "交易撤销", "REVOKED"),
    TRADE_FAIL(50, "交易失败", ""),
    REVERSE_SUCCESS(100, "退汇成功", ""),

    ;

    private final Integer code;
    private final String msn;
    private final String fubeiCode;

    /**
     * ！！这个方法只能给联动用，因为联动的枚举值是根据枚举的name()来的
     */
    public static Integer liandongTrans2code(String status) {
        for (PayStatusEnum value : PayStatusEnum.values()) {
            if (value.name().equals(status)) {
                return value.getCode();
            }
        }
        return null;
    }

    /**
     * ！！这个方法只能给付呗用，因为付呗的枚举值是根据fubeiCode来的
     */
    public static Integer fubeiTrans2code(String status) {
        for (PayStatusEnum value : PayStatusEnum.values()) {
            if (value.getFubeiCode().equals(status)) {
                return value.getCode();
            }
        }
        return null;
    }
}
