package cn.tuia.payment.api.dto.up;

import lombok.Data;

/**
 * @author lizhiheng
 */
@Data
public class UpBankMerReleasingNumConfig {
    private String industry;
    private int one;
    private int two;
    private int three;
    private int four;

    public static UpBankMerReleasingNumConfig defaultOne(String industry) {
        UpBankMerReleasingNumConfig bankMerReleasingNumConfig = new UpBankMerReleasingNumConfig();
        bankMerReleasingNumConfig.setIndustry(industry);
        bankMerReleasingNumConfig.setOne(20);
        bankMerReleasingNumConfig.setTwo(20);
        bankMerReleasingNumConfig.setThree(20);
        bankMerReleasingNumConfig.setFour(20);
        return bankMerReleasingNumConfig;
    }


    public int getReleasingNumByPeriod(int period) {
        if (period == 1) {
            return getOne();
        } else if (period == 2) {
            return getTwo();
        } else if (period == 3) {
            return getThree();
        } else {
            return getFour();
        }
    }
}
