package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 订单创建时候入库，需要存的短信模板信息，用于后续一个月的短信发送
 * @author lizhiheng
 */
@Data
@TableName("tb_pay_order_sms_template")
public class PayOrderSmsTemplateEntity implements Serializable {

    private static final long serialVersionUID = 1974815317802960095L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "CURRENT_TIMESTAMP")
    private Date gmtModified;

    /**
     * pay_order主表的订单id
     */
    @TableField("order_id")
    private String orderId;

    /**
     * 短信签名
     */
    @TableField("sms_sign")
    private String smsSign;

    /**
     * 短信模板
     */
    @TableField("sms_template")
    private String smsTemplate;

}