/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.dto;

import cn.tuia.payment.api.dto.MerchantExtraUPDTO;
import cn.tuia.payment.api.entity.BankMerPoolEntity;
import cn.tuia.payment.api.entity.MerchantEntity;
import cn.tuia.payment.api.enums.PaymentChannelEnum;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeanUtils;

public class MerchantDTO
extends MerchantEntity {
    private static final long serialVersionUID = -7955739852891154763L;
    private String poolName;
    private MerchantExtraUPDTO extraObject;

    public static MerchantDTO toDTO(MerchantEntity entity, Map<Long, BankMerPoolEntity> poolEntityMap) {
        MerchantDTO dto = new MerchantDTO();
        BeanUtils.copyProperties((Object)entity, (Object)dto);
        if (Objects.nonNull(poolEntityMap)) {
            if (Objects.equals(entity.getPoolId(), 0L)) {
                dto.setPoolName("\u9ed8\u8ba4\u6c60");
            } else {
                BankMerPoolEntity poolEntity = poolEntityMap.get(entity.getPoolId());
                if (Objects.nonNull(poolEntity)) {
                    dto.setPoolName(poolEntity.getName());
                }
            }
        }
        if (Objects.equals(entity.getChannel(), PaymentChannelEnum.UNION_PAY.getCode()) || Objects.equals(entity.getChannel(), PaymentChannelEnum.GUOGUANG.getCode())) {
            dto.setExtraObject((MerchantExtraUPDTO)JSON.parseObject((String)entity.getExtra(), MerchantExtraUPDTO.class));
        } else if (Objects.equals(entity.getChannel(), PaymentChannelEnum.UNION_PAY_SC.getCode())) {
            dto.setExtraObject((MerchantExtraUPDTO)JSON.parseObject((String)entity.getExtra(), MerchantExtraUPDTO.class));
        }
        return dto;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MerchantDTO)) {
            return false;
        }
        MerchantDTO other = (MerchantDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$poolName = this.getPoolName();
        String other$poolName = other.getPoolName();
        if (this$poolName == null ? other$poolName != null : !this$poolName.equals(other$poolName)) {
            return false;
        }
        MerchantExtraUPDTO this$extraObject = this.getExtraObject();
        MerchantExtraUPDTO other$extraObject = other.getExtraObject();
        return !(this$extraObject == null ? other$extraObject != null : !((Object)this$extraObject).equals(other$extraObject));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MerchantDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $poolName = this.getPoolName();
        result = result * 59 + ($poolName == null ? 43 : $poolName.hashCode());
        MerchantExtraUPDTO $extraObject = this.getExtraObject();
        result = result * 59 + ($extraObject == null ? 43 : ((Object)$extraObject).hashCode());
        return result;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public MerchantExtraUPDTO getExtraObject() {
        return this.extraObject;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setExtraObject(MerchantExtraUPDTO extraObject) {
        this.extraObject = extraObject;
    }

    @Override
    public String toString() {
        return "MerchantDTO(poolName=" + this.getPoolName() + ", extraObject=" + this.getExtraObject() + ")";
    }
}

