package cn.tuia.payment.api.dto;

import cn.tuia.payment.api.utils.TimePeriodUtil;
import lombok.Data;

import java.util.Arrays;

/**
 * @author lizhiheng
 */
@Data
public class BankMerReleasingNumConfig {
    private String merId;
    private int one;
    private int two;
    private int three;
    private int four;

    public static BankMerReleasingNumConfig defaultOne(String merId) {
        BankMerReleasingNumConfig bankMerReleasingNumConfig = new BankMerReleasingNumConfig();
        bankMerReleasingNumConfig.setMerId(merId);
        bankMerReleasingNumConfig.setOne(20);
        bankMerReleasingNumConfig.setTwo(20);
        bankMerReleasingNumConfig.setThree(20);
        bankMerReleasingNumConfig.setFour(20);
        return bankMerReleasingNumConfig;
    }


    public int getReleasingNumByPeriod(int period) {
        if (period == 1) {
            return getOne();
        } else if (period == 2) {
            return getTwo();
        } else if (period == 3) {
            return getThree();
        } else {
            return getFour();
        }
    }

    public int[] getReleasingTimeByPeriod(int period) {
        if (period == 1) {
            return new int[]{0, 6};
        } else if (period == 2) {
            return new int[]{6, 12};
        } else if (period == 3) {
            return new int[]{12, 18};
        } else {
            return new int[]{18, 24};
        }
    }
}
