/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.enums;

import cn.tuia.payment.api.enums.ali.AlipayFundTransferStatusEnum;
import java.util.Objects;

public enum ActOrderTransferStatusEnum {
    INITIAL(0, "\u521d\u59cb\u503c"),
    ING(10, "\u8f6c\u8d26\u4e2d"),
    SUCCESS(20, "\u8f6c\u8d26\u6210\u529f"),
    FAILED(30, "\u8f6c\u8d26\u5931\u8d25");

    private final Integer code;
    private final String msg;

    public static ActOrderTransferStatusEnum convert(String aliStatusEnum) {
        if (Objects.isNull(aliStatusEnum)) {
            return null;
        }
        if (aliStatusEnum.equals(AlipayFundTransferStatusEnum.SUCCESS.getCode())) {
            return SUCCESS;
        }
        if (aliStatusEnum.equals(AlipayFundTransferStatusEnum.FAIL.getCode()) || aliStatusEnum.equals(AlipayFundTransferStatusEnum.REFUND.getCode())) {
            return FAILED;
        }
        return ING;
    }

    public static boolean ini(Integer status) {
        return Objects.nonNull(status) && status.equals(ActOrderTransferStatusEnum.INITIAL.code);
    }

    public static boolean success(Integer status) {
        return Objects.nonNull(status) && status.equals(ActOrderTransferStatusEnum.SUCCESS.code);
    }

    public static boolean failed(Integer status) {
        return Objects.nonNull(status) && status.equals(ActOrderTransferStatusEnum.FAILED.code);
    }

    public static boolean ing(Integer status) {
        return Objects.nonNull(status) && status.equals(ActOrderTransferStatusEnum.ING.code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    private ActOrderTransferStatusEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }
}

