package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 子商户表在投状态更新记录
 * @author lizhiheng
 */
@Data
@TableName("tb_bank_mer_change_log")
public class BankMerChangeLogEntity implements Serializable {

    private static final long serialVersionUID = -5898348745684171658L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "CURRENT_TIMESTAMP")
    private Date gmtModified;

    /**
     * 之前的投放状态
     */
    @TableField("before_release_status")
    private Integer beforeReleaseStatus;

    /**
     * 之后的投放状态
     */
    @TableField("after_release_status")
    private Integer afterReleaseStatus;

    /**
     * 主商户ID
     */
    @TableField("mer_id")
    private String merId;

    /**
     * 子商户ID
     */
    @TableField("bank_mer_id")
    private String bankMerId;

    /**
     * 最近更新人
     */
    @TableField("admin_id")
    private String adminId;

}