package cn.tuia.payment.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.BankMerDTO;
import cn.tuia.payment.api.dto.req.BankMerQuery;
import cn.tuia.payment.api.dto.req.ReqPageQuery;
import cn.tuia.payment.api.dto.rsp.ResultPage;
import cn.tuia.payment.api.entity.BankMerEntity;

import java.util.List;
import java.util.Set;

/**
 * @author lizhiheng
 */
@AdvancedFeignClient
public interface RemoteBankMerService {

    ResultPage<BankMerDTO> page(ReqPageQuery<BankMerQuery> query);

    List<BankMerDTO> list(ReqPageQuery<BankMerQuery> query);

    boolean updateOrSaveBankMer(BankMerEntity newOne);

    /**
     * 编辑单个
     */
    boolean updateById(BankMerEntity bankMer);

    Set<String> membersFromThePool(String merId, Integer timePeriod);
}
