package cn.tuia.payment.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.entity.RefundOrderEntity;

import java.util.List;

/**
 * @author lizhiheng
 */
@AdvancedFeignClient
public interface RemoteRefundOrderService {

    Long save(RefundOrderEntity refundOrderEntity);

    boolean updateByMultiId(RefundOrderEntity refundOrderEntity);

    boolean updateByRefundNo(RefundOrderEntity refundOrderEntity);

    List<RefundOrderEntity> selectAllMiddleNightRefundOrder();

    List<RefundOrderEntity> selectNotRefundYetOrder();

    RefundOrderEntity getByRefundNo(String refundNo);

    List<RefundOrderEntity> getByOrderId(String orderId);

    List<RefundOrderEntity> getByBankOrderId(String bankOrderId);
    RefundOrderEntity getOneByBankOrderId(String bankOrderId);

    /**
     * 查询上个月今天退款单
     */
    List<RefundOrderEntity> getTheSameDayLastMonthData();
}
