package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 概率上传主表实体类
 * @author assistant
 */
@Data
@TableName("tb_probability_report")
public class ProbabilityReportEntity implements Serializable {
    private static final long serialVersionUID = -1169834453871706006L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 积木id
     */
    @TableField("jimu_id")
    private String jimuId;

    /**
     * 行业，1、短剧 2、会籍卡
     */
    @TableField("industry")
    private Integer industry;

    /**
     * 最后编辑人
     */
    @TableField("last_admin_id")
    private String lastAdminId;

    /**
     * 最后编辑时间
     */
    @TableField("last_edit_time")
    private Date lastEditTime;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 记录创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 记录更新时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;
} 