package cn.tuia.payment.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.BankMerDTO;
import cn.tuia.payment.api.dto.req.BankMerQuery;
import cn.tuia.payment.api.dto.req.ReqPageQuery;
import cn.tuia.payment.api.dto.rsp.ResultPage;
import cn.tuia.payment.api.entity.BankMerEntity;
import cn.tuia.payment.api.entity.UpBankMerEntity;

import java.util.List;
import java.util.Set;

/**
 * @author lizhiheng
 */
@AdvancedFeignClient
public interface RemoteBankMerService {

    BankMerEntity getById(Long id);

    ResultPage<BankMerDTO> page(ReqPageQuery<BankMerQuery> query);

    List<BankMerDTO> list(ReqPageQuery<BankMerQuery> query);

    boolean updateOrSaveBankMer(BankMerEntity newOne);

    /**
     * 编辑单个,简单更新（无其他业务逻辑）用这个，带逻辑的请用updateOrSaveBankMer
     */
    boolean updateById(BankMerEntity bankMer);

    Set<String> membersFromThePool(String merId, Integer timePeriod);


    Set<String> membersFromThePoolV2(String merId, Integer timePeriod, Long poolId);

    List<BankMerEntity> getRandomListByTimePeriodAndReleasingStatus(String merId, Integer timePeriod, Integer releasingStatus, Integer num, Integer onOff, Long poolId);

    BankMerEntity getByBankMerId(String merId, String bankMerId);
}
