package cn.tuia.payment.api.constants;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;

/**
 * @author y.zhao
 * @title: RedisKeyEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.09.13 10:26
 */
@Getter
@AllArgsConstructor
public enum RedisKeyEnum {

    BANK_MER_POOL_ID_SET("%s_BANK_MER_POOL_ID_SET", 1, TimeUnit.DAYS),
    BANK_MER_POOL_4_RELATION("%s_BANK_MER_POOL_4_RELATION", 1, TimeUnit.DAYS),
    BANK_MER_POOL_4_POOL_ID("%s_BANK_MER_POOL_4_POOL_ID", 1, TimeUnit.DAYS),

    REFUND_SUCCESS_SMS("%s_REFUND_SUCCESS_SMS", 1, TimeUnit.DAYS),
    REFUND_FAILED_SMS("%s_REFUND_FAILED_SMS", 3, TimeUnit.DAYS),

    V2_REPORT_NON_COLD_START_SET("V2_REPORT_NON_COLD_START_SET_%s_%s", 1, TimeUnit.DAYS),

    /** 积木页冷启动全局计数 */
    V2_REPORT_JIMU_COLD_START_GLOBAL("V2_REPORT_JIMU_COLD_START_GLOBAL_%s_%s", 1, TimeUnit.DAYS),
    /** 积木页冷启动全局计数 */
    V2_REPORT_JIMU_COLD_START_SLOT_TOTAL("V2_REPORT_JIMU_COLD_START_SLOT_%s_%s", 1, TimeUnit.DAYS),
    /** 积木页冷启动广告位计数 */
    V2_REPORT_JIMU_COLD_START_SLOT("V2_REPORT_JIMU_COLD_START_SLOT_%s_%s_%s", 1, TimeUnit.DAYS),

    ;

    private final String key;
    private final Integer timeout;
    private final TimeUnit unit;

    public static String getNonColdStartSet(String jimuId) {
        return String.format(V2_REPORT_NON_COLD_START_SET.getKey(), LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")), jimuId);
    }

    public static String getColdStartCountGlobal(String jimuId) {
        return String.format(V2_REPORT_JIMU_COLD_START_GLOBAL.getKey(), LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")), jimuId);
    }

    public static String getColdStartCountSlotTotal(String jimuId) {
        return String.format(V2_REPORT_JIMU_COLD_START_SLOT_TOTAL.getKey(), LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")), jimuId);
    }

    public static String getColdStartCountSlot(String jimuId, String slotId) {
        return String.format(V2_REPORT_JIMU_COLD_START_SLOT.getKey(), LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")), jimuId, slotId);
    }

    /**
     * 退款失败 key
     *
     * @param orderId
     * @return
     */
    public static String getRefundFailedSmsKey(String orderId) {
        return String.format(REFUND_FAILED_SMS.getKey(), orderId);
    }

    /**
     * 退款成功 key
     *
     * @param orderId
     * @return
     */
    public static String getRefundSuccessSmsKey(String orderId) {
        return String.format(REFUND_SUCCESS_SMS.getKey(), orderId);
    }

    /**
     * 商户池信息缓存key （关联积木id）
     */
    public static String getRelationKey(String relationId) {
        return String.format(BANK_MER_POOL_4_RELATION.getKey(), relationId);
    }

    /**
     * 商户池信息缓存key （pool_id）
     */
    public static String getPoolIdKey(Long poolId) {
        return String.format(BANK_MER_POOL_4_POOL_ID.getKey(), poolId);
    }

    /**
     * 渠道 商户池id_set key
     *
     * @param paymentChannel
     * @return
     */
    public static String getChannelPoolKey(Integer paymentChannel) {
        return String.format(BANK_MER_POOL_ID_SET.getKey(), paymentChannel);
    }
}
