package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: ComplainStatusFubeiEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2025.02.26 16:19
 */
@Getter
@AllArgsConstructor
public enum ComplainStatusFubeiEnum {

    PENDING("1", "待处理", ComplainStatusEnum.WAIT_PROCESS.name()),
    PROCESSING("2", "处理中", ComplainStatusEnum.PROCESSING.name()),
    PROCESSED("3", "已处理完成", ComplainStatusEnum.PROCESSED.name()),
    DROP_COMPLAIN("4", "已撤诉", ComplainStatusEnum.DROP_COMPLAIN.name()),
    ;

    private final String code;
    private final String description;
    private final String commonComplaintStatus;

    public static String getName(String code) {
        for (ComplainStatusFubeiEnum value : ComplainStatusFubeiEnum.values()) {
            if (value.getCode().equals(code)) {
                return value.getCommonComplaintStatus();
            }
        }
        return null;
    }
}
