/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.dto;

import cn.tuia.payment.api.entity.CustomerComplaintEntity;
import cn.tuia.payment.api.entity.PayOrderEntity;
import cn.tuia.payment.api.entity.RefundOrderEntity;
import cn.tuia.payment.api.enums.ComplainChannelEnum;
import cn.tuia.payment.api.enums.ComplainStatusEnum;
import cn.tuia.payment.api.enums.ComplainStatusFubeiEnum;
import cn.tuia.payment.api.enums.ComplainStatusLiandongWxEnum;
import cn.tuia.payment.api.enums.ComplaintRefundStatusEnum;
import cn.tuia.payment.api.enums.OrderRefundStatusEnum;
import cn.tuia.payment.api.enums.PaymentChannelEnum;
import cn.tuia.payment.api.enums.TuiaPayWayEnum;
import cn.tuia.payment.api.utils.AmountUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class CompliantDTO
implements Serializable {
    private static final long serialVersionUID = -492835667053444344L;
    private Long id;
    private Integer channel;
    private String channelName;
    private String complainNo;
    private String bankOrderId;
    private String merOrderNo;
    private String orderAmount;
    private Date gmtTrade;
    private Date gmtComplain;
    private String complainStatus;
    private String complainStatusDesc;
    private String contact;
    private String complainContent;
    private String refundAmount;
    private Integer refundStatus;
    private String refundStatusDesc;
    private Date gmtRefund;
    private String payWay;
    private Integer telFlag;
    private Integer msgFlag;
    private Integer refundFlag;
    private String phone;

    public static CompliantDTO convert(CustomerComplaintEntity entity, Map<String, PayOrderEntity> orderEntityMap, Map<String, List<RefundOrderEntity>> refundMap) {
        PayOrderEntity payOrderEntity;
        CompliantDTO dto = new CompliantDTO();
        BeanUtils.copyProperties((Object)entity, (Object)dto);
        dto.setBankOrderId(entity.getBankOrderNo());
        dto.setChannelName(ComplainChannelEnum.getMsg(entity.getChannel()));
        dto.setComplainStatus(entity.getStatus());
        if (entity.getChannel().equals(PaymentChannelEnum.FU_BEI.getCode())) {
            dto.setComplainStatusDesc(ComplainStatusFubeiEnum.getName(entity.getStatus()));
        } else if (entity.getChannel().equals(PaymentChannelEnum.LIANDONG_V2.getCode())) {
            dto.setComplainStatusDesc(ComplainStatusLiandongWxEnum.getCommonComplaintStatus(entity.getStatus()));
        } else {
            dto.setComplainStatusDesc(ComplainStatusEnum.getDesc(entity.getStatus()));
        }
        dto.setRefundAmount(AmountUtil.convertRefundAmountToString(entity.getRefundAmount()));
        dto.setRefundStatus(entity.getRefundStatus());
        dto.setRefundStatusDesc(ComplaintRefundStatusEnum.getDesc(dto.getRefundStatus()));
        if (Objects.nonNull(orderEntityMap) && Objects.nonNull(payOrderEntity = orderEntityMap.get(entity.getBankOrderNo()))) {
            List<RefundOrderEntity> refundOrderEntityList;
            dto.setRefundStatus(payOrderEntity.getRefundStatus());
            dto.setRefundStatusDesc(OrderRefundStatusEnum.getDescByCode(payOrderEntity.getRefundStatus()));
            dto.setGmtRefund(payOrderEntity.getGmtModified());
            dto.setPhone(payOrderEntity.getPhone());
            if (Objects.nonNull(refundMap) && refundMap.containsKey(payOrderEntity.getBankOrderId()) && CollectionUtils.isNotEmpty(refundOrderEntityList = refundMap.get(payOrderEntity.getBankOrderId()))) {
                Long reduce = refundOrderEntityList.stream().map(RefundOrderEntity::getRefundAmount).reduce(0L, Long::sum);
                dto.setRefundAmount(AmountUtil.convertRefundAmountToString(reduce));
                dto.setGmtRefund(refundOrderEntityList.get(0).getRefundTime());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getPayWay())) {
            boolean contains;
            boolean bl = contains = Objects.nonNull(entity.getPayWay()) && TuiaPayWayEnum.ALI_PAY.contains(Integer.valueOf(entity.getPayWay()));
            if (contains) {
                dto.setPayWay(TuiaPayWayEnum.ALIPAY.getName());
            } else {
                dto.setPayWay(TuiaPayWayEnum.WECHAT_PAY.getName());
            }
        } else {
            dto.setPayWay(TuiaPayWayEnum.ALIPAY.getName());
        }
        return dto;
    }

    public Long getId() {
        return this.id;
    }

    public Integer getChannel() {
        return this.channel;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getComplainNo() {
        return this.complainNo;
    }

    public String getBankOrderId() {
        return this.bankOrderId;
    }

    public String getMerOrderNo() {
        return this.merOrderNo;
    }

    public String getOrderAmount() {
        return this.orderAmount;
    }

    public Date getGmtTrade() {
        return this.gmtTrade;
    }

    public Date getGmtComplain() {
        return this.gmtComplain;
    }

    public String getComplainStatus() {
        return this.complainStatus;
    }

    public String getComplainStatusDesc() {
        return this.complainStatusDesc;
    }

    public String getContact() {
        return this.contact;
    }

    public String getComplainContent() {
        return this.complainContent;
    }

    public String getRefundAmount() {
        return this.refundAmount;
    }

    public Integer getRefundStatus() {
        return this.refundStatus;
    }

    public String getRefundStatusDesc() {
        return this.refundStatusDesc;
    }

    public Date getGmtRefund() {
        return this.gmtRefund;
    }

    public String getPayWay() {
        return this.payWay;
    }

    public Integer getTelFlag() {
        return this.telFlag;
    }

    public Integer getMsgFlag() {
        return this.msgFlag;
    }

    public Integer getRefundFlag() {
        return this.refundFlag;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public void setComplainNo(String complainNo) {
        this.complainNo = complainNo;
    }

    public void setBankOrderId(String bankOrderId) {
        this.bankOrderId = bankOrderId;
    }

    public void setMerOrderNo(String merOrderNo) {
        this.merOrderNo = merOrderNo;
    }

    public void setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
    }

    public void setGmtTrade(Date gmtTrade) {
        this.gmtTrade = gmtTrade;
    }

    public void setGmtComplain(Date gmtComplain) {
        this.gmtComplain = gmtComplain;
    }

    public void setComplainStatus(String complainStatus) {
        this.complainStatus = complainStatus;
    }

    public void setComplainStatusDesc(String complainStatusDesc) {
        this.complainStatusDesc = complainStatusDesc;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public void setComplainContent(String complainContent) {
        this.complainContent = complainContent;
    }

    public void setRefundAmount(String refundAmount) {
        this.refundAmount = refundAmount;
    }

    public void setRefundStatus(Integer refundStatus) {
        this.refundStatus = refundStatus;
    }

    public void setRefundStatusDesc(String refundStatusDesc) {
        this.refundStatusDesc = refundStatusDesc;
    }

    public void setGmtRefund(Date gmtRefund) {
        this.gmtRefund = gmtRefund;
    }

    public void setPayWay(String payWay) {
        this.payWay = payWay;
    }

    public void setTelFlag(Integer telFlag) {
        this.telFlag = telFlag;
    }

    public void setMsgFlag(Integer msgFlag) {
        this.msgFlag = msgFlag;
    }

    public void setRefundFlag(Integer refundFlag) {
        this.refundFlag = refundFlag;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompliantDTO)) {
            return false;
        }
        CompliantDTO other = (CompliantDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$channel = this.getChannel();
        Integer other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        Integer this$refundStatus = this.getRefundStatus();
        Integer other$refundStatus = other.getRefundStatus();
        if (this$refundStatus == null ? other$refundStatus != null : !((Object)this$refundStatus).equals(other$refundStatus)) {
            return false;
        }
        Integer this$telFlag = this.getTelFlag();
        Integer other$telFlag = other.getTelFlag();
        if (this$telFlag == null ? other$telFlag != null : !((Object)this$telFlag).equals(other$telFlag)) {
            return false;
        }
        Integer this$msgFlag = this.getMsgFlag();
        Integer other$msgFlag = other.getMsgFlag();
        if (this$msgFlag == null ? other$msgFlag != null : !((Object)this$msgFlag).equals(other$msgFlag)) {
            return false;
        }
        Integer this$refundFlag = this.getRefundFlag();
        Integer other$refundFlag = other.getRefundFlag();
        if (this$refundFlag == null ? other$refundFlag != null : !((Object)this$refundFlag).equals(other$refundFlag)) {
            return false;
        }
        String this$channelName = this.getChannelName();
        String other$channelName = other.getChannelName();
        if (this$channelName == null ? other$channelName != null : !this$channelName.equals(other$channelName)) {
            return false;
        }
        String this$complainNo = this.getComplainNo();
        String other$complainNo = other.getComplainNo();
        if (this$complainNo == null ? other$complainNo != null : !this$complainNo.equals(other$complainNo)) {
            return false;
        }
        String this$bankOrderId = this.getBankOrderId();
        String other$bankOrderId = other.getBankOrderId();
        if (this$bankOrderId == null ? other$bankOrderId != null : !this$bankOrderId.equals(other$bankOrderId)) {
            return false;
        }
        String this$merOrderNo = this.getMerOrderNo();
        String other$merOrderNo = other.getMerOrderNo();
        if (this$merOrderNo == null ? other$merOrderNo != null : !this$merOrderNo.equals(other$merOrderNo)) {
            return false;
        }
        String this$orderAmount = this.getOrderAmount();
        String other$orderAmount = other.getOrderAmount();
        if (this$orderAmount == null ? other$orderAmount != null : !this$orderAmount.equals(other$orderAmount)) {
            return false;
        }
        Date this$gmtTrade = this.getGmtTrade();
        Date other$gmtTrade = other.getGmtTrade();
        if (this$gmtTrade == null ? other$gmtTrade != null : !((Object)this$gmtTrade).equals(other$gmtTrade)) {
            return false;
        }
        Date this$gmtComplain = this.getGmtComplain();
        Date other$gmtComplain = other.getGmtComplain();
        if (this$gmtComplain == null ? other$gmtComplain != null : !((Object)this$gmtComplain).equals(other$gmtComplain)) {
            return false;
        }
        String this$complainStatus = this.getComplainStatus();
        String other$complainStatus = other.getComplainStatus();
        if (this$complainStatus == null ? other$complainStatus != null : !this$complainStatus.equals(other$complainStatus)) {
            return false;
        }
        String this$complainStatusDesc = this.getComplainStatusDesc();
        String other$complainStatusDesc = other.getComplainStatusDesc();
        if (this$complainStatusDesc == null ? other$complainStatusDesc != null : !this$complainStatusDesc.equals(other$complainStatusDesc)) {
            return false;
        }
        String this$contact = this.getContact();
        String other$contact = other.getContact();
        if (this$contact == null ? other$contact != null : !this$contact.equals(other$contact)) {
            return false;
        }
        String this$complainContent = this.getComplainContent();
        String other$complainContent = other.getComplainContent();
        if (this$complainContent == null ? other$complainContent != null : !this$complainContent.equals(other$complainContent)) {
            return false;
        }
        String this$refundAmount = this.getRefundAmount();
        String other$refundAmount = other.getRefundAmount();
        if (this$refundAmount == null ? other$refundAmount != null : !this$refundAmount.equals(other$refundAmount)) {
            return false;
        }
        String this$refundStatusDesc = this.getRefundStatusDesc();
        String other$refundStatusDesc = other.getRefundStatusDesc();
        if (this$refundStatusDesc == null ? other$refundStatusDesc != null : !this$refundStatusDesc.equals(other$refundStatusDesc)) {
            return false;
        }
        Date this$gmtRefund = this.getGmtRefund();
        Date other$gmtRefund = other.getGmtRefund();
        if (this$gmtRefund == null ? other$gmtRefund != null : !((Object)this$gmtRefund).equals(other$gmtRefund)) {
            return false;
        }
        String this$payWay = this.getPayWay();
        String other$payWay = other.getPayWay();
        if (this$payWay == null ? other$payWay != null : !this$payWay.equals(other$payWay)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompliantDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        Integer $refundStatus = this.getRefundStatus();
        result = result * 59 + ($refundStatus == null ? 43 : ((Object)$refundStatus).hashCode());
        Integer $telFlag = this.getTelFlag();
        result = result * 59 + ($telFlag == null ? 43 : ((Object)$telFlag).hashCode());
        Integer $msgFlag = this.getMsgFlag();
        result = result * 59 + ($msgFlag == null ? 43 : ((Object)$msgFlag).hashCode());
        Integer $refundFlag = this.getRefundFlag();
        result = result * 59 + ($refundFlag == null ? 43 : ((Object)$refundFlag).hashCode());
        String $channelName = this.getChannelName();
        result = result * 59 + ($channelName == null ? 43 : $channelName.hashCode());
        String $complainNo = this.getComplainNo();
        result = result * 59 + ($complainNo == null ? 43 : $complainNo.hashCode());
        String $bankOrderId = this.getBankOrderId();
        result = result * 59 + ($bankOrderId == null ? 43 : $bankOrderId.hashCode());
        String $merOrderNo = this.getMerOrderNo();
        result = result * 59 + ($merOrderNo == null ? 43 : $merOrderNo.hashCode());
        String $orderAmount = this.getOrderAmount();
        result = result * 59 + ($orderAmount == null ? 43 : $orderAmount.hashCode());
        Date $gmtTrade = this.getGmtTrade();
        result = result * 59 + ($gmtTrade == null ? 43 : ((Object)$gmtTrade).hashCode());
        Date $gmtComplain = this.getGmtComplain();
        result = result * 59 + ($gmtComplain == null ? 43 : ((Object)$gmtComplain).hashCode());
        String $complainStatus = this.getComplainStatus();
        result = result * 59 + ($complainStatus == null ? 43 : $complainStatus.hashCode());
        String $complainStatusDesc = this.getComplainStatusDesc();
        result = result * 59 + ($complainStatusDesc == null ? 43 : $complainStatusDesc.hashCode());
        String $contact = this.getContact();
        result = result * 59 + ($contact == null ? 43 : $contact.hashCode());
        String $complainContent = this.getComplainContent();
        result = result * 59 + ($complainContent == null ? 43 : $complainContent.hashCode());
        String $refundAmount = this.getRefundAmount();
        result = result * 59 + ($refundAmount == null ? 43 : $refundAmount.hashCode());
        String $refundStatusDesc = this.getRefundStatusDesc();
        result = result * 59 + ($refundStatusDesc == null ? 43 : $refundStatusDesc.hashCode());
        Date $gmtRefund = this.getGmtRefund();
        result = result * 59 + ($gmtRefund == null ? 43 : ((Object)$gmtRefund).hashCode());
        String $payWay = this.getPayWay();
        result = result * 59 + ($payWay == null ? 43 : $payWay.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        return result;
    }

    public String toString() {
        return "CompliantDTO(id=" + this.getId() + ", channel=" + this.getChannel() + ", channelName=" + this.getChannelName() + ", complainNo=" + this.getComplainNo() + ", bankOrderId=" + this.getBankOrderId() + ", merOrderNo=" + this.getMerOrderNo() + ", orderAmount=" + this.getOrderAmount() + ", gmtTrade=" + this.getGmtTrade() + ", gmtComplain=" + this.getGmtComplain() + ", complainStatus=" + this.getComplainStatus() + ", complainStatusDesc=" + this.getComplainStatusDesc() + ", contact=" + this.getContact() + ", complainContent=" + this.getComplainContent() + ", refundAmount=" + this.getRefundAmount() + ", refundStatus=" + this.getRefundStatus() + ", refundStatusDesc=" + this.getRefundStatusDesc() + ", gmtRefund=" + this.getGmtRefund() + ", payWay=" + this.getPayWay() + ", telFlag=" + this.getTelFlag() + ", msgFlag=" + this.getMsgFlag() + ", refundFlag=" + this.getRefundFlag() + ", phone=" + this.getPhone() + ")";
    }
}

