package cn.tuia.payment.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author : lizhiheng
 */
@Data
public class PayOrderDTO implements Serializable {
    private static final long serialVersionUID = 2374917909195647818L;

    /**
     * 传入的手机号，会一并返回
     * 有手机号，但是无date的情况，说明该用户没有支付成功的订单
     */
    private String phone;
    /**
     * 最新一笔订单的支付时间
     */
    private Date latestOrderPayTime;
    /**
     * 最新一笔订单的支付订单号
     */
    private String bankOrderId;

    /**
     * 订单积木Id
     */
    public String jimuId;

    public PayOrderDTO(String phone) {
        this.phone = phone;
    }
}
