package cn.tuia.payment.api.dto.req;

import lombok.Data;

import java.io.Serializable;

/**
 * @author y.zhao
 * @title: ComplaintQuery
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.07 10:14
 */
@Data
public class ComplaintQuery implements Serializable {
    private static final long serialVersionUID = -7220675763996287618L;

    /**
     * 投诉开始时间
     */
    private String compliantStartTime;

    /**
     * 投诉结束时间
     */
    private String compliantEndTime;

    /**
     * 渠道 1-银联
     */
    private Integer channel;

    /**
     * 投诉状态
     *
     * @see cn.tuia.payment.api.enums.ComplainStatusEnum
     */
    private String compliantStatus;

    /**
     * 支付方式
     */
    private Integer payWay;

    /**
     * 退款结果
     * 0-未退款 1-退款成功 2-退款中 3-退款失败
     */
    private Integer refundStatus;

}
