package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: PaymentProductEntity
 * @projectName tuia-payment-center
 * @description: description
 * @date 2025.02.25 17:49
 */
@Data
@TableName("tb_payment_product")
public class PaymentProductEntity implements Serializable {
    private static final long serialVersionUID = -7158383735894937284L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    /**
     * 名称
     */
    @TableField("name")
    private String name;

    /**
     * 积分值
     */
    @TableField("points")
    private Integer points;

    /**
     * 积分有效期
     */
    @TableField("point_valid")
    private Integer pointValid;

    /**
     * 扩展字段
     */
    @TableField("extra")
    private String extra;
}
