package cn.tuia.payment.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.PayOrderDTO;
import cn.tuia.payment.api.dto.SettleAndSplitPayOrderDTO;

import java.util.List;


/**
 * 只读库-支付表数据
 */
@AdvancedFeignClient
public interface RemoteRoPayOrderService {

    /**
     * 根据手机号或者流水号获取
     */
    PayOrderDTO getSuccessPayOrderByPhone(String phone);

    /**
     * 根据jimuId获取到今天支付成功的订单数量
     */
    Integer getTodayPreReplenishAmountByJimuId(String jimuId, String bankMerId);

    /**
     * 获取特定时间里的需要结算的订单
     */
    List<SettleAndSplitPayOrderDTO> getNeedSettleAndSplitOrder(String startTime, String endTime);

}
